/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.hooks;

import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.hooks.OptifineHook;
import club.sk1er.patcher.util.enhancement.EnhancementManager;
import club.sk1er.patcher.util.enhancement.text.CachedString;
import club.sk1er.patcher.util.enhancement.text.EnhancedFontRenderer;
import club.sk1er.patcher.util.hash.StringHash;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Pair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public final class FontRendererHook {
    public static boolean forceRefresh = false;
    private final EnhancedFontRenderer enhancedFontRenderer = EnhancementManager.getInstance().getEnhancement(EnhancedFontRenderer.class);
    private final FontRenderer fontRenderer;
    private final String characterDictionary = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
    private final Minecraft mc = Minecraft.func_71410_x();
    public int GL_TEX = -1;
    private OptifineHook hook = new OptifineHook();
    private int texSheetDim = 256;
    private float fontTexHeight = 16 * this.texSheetDim + 128;
    private float fontTexWidth = 16 * this.texSheetDim;
    private int regularCharDim = 128;
    private boolean drawing = false;

    public FontRendererHook(FontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
    }

    private void establishSize() {
        int regWidth = 256;
        for (int i = 0; i < 256; ++i) {
            ResourceLocation resourceLocation = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", i));
            try {
                IResource resource = this.mc.func_110442_L().func_110536_a(resourceLocation);
                try (InputStream stream = resource.func_110527_b();){
                    BufferedImage read = ImageIO.read(stream);
                    regWidth = read.getWidth();
                    break;
                }
            }
            catch (IOException resource) {
                continue;
            }
        }
        this.texSheetDim = regWidth;
        int specWidth = 128;
        try {
            IResource resource = this.mc.func_110442_L().func_110536_a(this.fontRenderer.field_111273_g);
            try (InputStream stream = resource.func_110527_b();){
                BufferedImage read = ImageIO.read(stream);
                specWidth = read.getWidth();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.regularCharDim = specWidth;
        this.fontTexHeight = 16 * this.texSheetDim + specWidth;
        this.fontTexWidth = 16 * this.texSheetDim;
    }

    private void create() {
        this.establishSize();
        this.hook = new OptifineHook();
        forceRefresh = false;
        if (this.GL_TEX != -1) {
            GlStateManager.func_179150_h((int)this.GL_TEX);
        }
        BufferedImage bufferedImage = new BufferedImage((int)this.fontTexWidth, (int)this.fontTexHeight, 2);
        for (int i = 0; i < 256; ++i) {
            ResourceLocation resourceLocation = new ResourceLocation(String.format("textures/font/unicode_page_%02x.png", i));
            try {
                IResource resource = this.mc.func_110442_L().func_110536_a(resourceLocation);
                try (InputStream stream = resource.func_110527_b();){
                    BufferedImage read = ImageIO.read(stream);
                    bufferedImage.getGraphics().drawImage(read, i / 16 * this.texSheetDim, i % 16 * this.texSheetDim, null);
                    continue;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            IResource resource = this.mc.func_110442_L().func_110536_a(this.fontRenderer.field_111273_g);
            try (InputStream stream = resource.func_110527_b();){
                BufferedImage read = ImageIO.read(stream);
                bufferedImage.getGraphics().drawImage(read, 0, 16 * this.texSheetDim, null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DynamicTexture dynamicTexture = new DynamicTexture(bufferedImage);
        this.GL_TEX = dynamicTexture.func_110552_b();
    }

    public boolean renderStringAtPos(String text, boolean shadow) {
        boolean hasStyle;
        CachedString cachedString;
        if (this.fontRenderer.field_78298_i == null || !PatcherConfig.optimizedFontRenderer) {
            if (this.GL_TEX != -1) {
                GlStateManager.func_179150_h((int)this.GL_TEX);
                this.GL_TEX = -1;
            }
            return false;
        }
        if (this.GL_TEX == -1 || forceRefresh) {
            this.create();
        }
        this.fontRenderer.field_78303_s = false;
        this.fontRenderer.field_78302_t = false;
        this.fontRenderer.field_78301_u = false;
        this.fontRenderer.field_78300_v = false;
        this.fontRenderer.field_78299_w = false;
        while (text.startsWith("\u00a7r")) {
            text = text.substring(2);
        }
        while (text.endsWith("\u00a7r")) {
            text = text.substring(0, text.length() - 2);
        }
        int list = 0;
        float posX = this.fontRenderer.field_78295_j;
        float posY = this.fontRenderer.field_78296_k;
        this.fontRenderer.field_78296_k = 0.0f;
        this.fontRenderer.field_78295_j = 0.0f;
        float red = this.fontRenderer.field_78291_n;
        float green = this.fontRenderer.field_78306_p;
        float blue = this.fontRenderer.field_78292_o;
        float alpha = this.fontRenderer.field_78305_q;
        StringHash hash = new StringHash(text, red, green, blue, alpha, shadow);
        GlStateManager.func_179144_i((int)this.GL_TEX);
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)0.0f);
        GlStateManager.TextureState[] textureStates = GlStateManager.field_179174_p;
        int activeTextureUnit = GlStateManager.field_179162_o;
        GlStateManager.TextureState textureState = textureStates[activeTextureUnit];
        boolean cacheFontData = PatcherConfig.cacheFontData;
        CachedString cachedString2 = cachedString = cacheFontData ? this.enhancedFontRenderer.get(hash) : null;
        if (cachedString != null) {
            GlStateManager.func_179131_c((float)red, (float)blue, (float)green, (float)alpha);
            GlStateManager.func_179148_o((int)cachedString.getListId());
            textureState.field_179059_b = this.GL_TEX;
            GlStateManager.Color colorState = GlStateManager.field_179170_t;
            colorState.field_179195_a = cachedString.getLastRed();
            colorState.field_179193_b = cachedString.getLastGreen();
            colorState.field_179194_c = cachedString.getLastBlue();
            colorState.field_179192_d = cachedString.getLastAlpha();
            GlStateManager.func_179109_b((float)(-posX), (float)(-posY), (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.fontRenderer.field_78295_j = posX + cachedString.getWidth();
            this.fontRenderer.field_78296_k = posY + cachedString.getHeight();
            return true;
        }
        textureState.field_179059_b = this.GL_TEX;
        GlStateManager.func_179117_G();
        if (cacheFontData) {
            list = this.enhancedFontRenderer.getGlList();
            GL11.glNewList((int)list, (int)4865);
        }
        boolean obfuscated = false;
        CachedString value = new CachedString(text, list, this.fontRenderer.field_78295_j - posX, this.fontRenderer.field_78296_k - posY);
        int[] colorCode = this.fontRenderer.field_78285_g;
        LinkedList<RenderPair> underline = new LinkedList<RenderPair>();
        LinkedList<RenderPair> strikeThough = new LinkedList<RenderPair>();
        for (int messageChar = 0; messageChar < text.length(); ++messageChar) {
            boolean small;
            int obfuscationIndex;
            char letter = text.charAt(messageChar);
            if (letter == '\u00a7' && messageChar + 1 < text.length()) {
                int styleIndex = "0123456789abcdefklmnor".indexOf(text.toLowerCase(Locale.ENGLISH).charAt(messageChar + 1));
                if (styleIndex < 16) {
                    int j1;
                    this.fontRenderer.field_78299_w = false;
                    this.fontRenderer.field_78300_v = false;
                    this.fontRenderer.field_78301_u = false;
                    this.fontRenderer.field_78303_s = false;
                    this.fontRenderer.field_78302_t = false;
                    if (styleIndex < 0) {
                        styleIndex = 15;
                    }
                    if (shadow) {
                        styleIndex += 16;
                    }
                    this.fontRenderer.field_78304_r = j1 = colorCode[styleIndex];
                    float colorRed = (float)(j1 >> 16) / 255.0f;
                    float colorGreen = (float)(j1 >> 8 & 0xFF) / 255.0f;
                    float colorBlue = (float)(j1 & 0xFF) / 255.0f;
                    GlStateManager.func_179131_c((float)colorRed, (float)colorGreen, (float)colorBlue, (float)alpha);
                    value.setLastAlpha(alpha);
                    value.setLastGreen(colorGreen);
                    value.setLastBlue(colorBlue);
                    value.setLastRed(colorRed);
                } else if (styleIndex == 16) {
                    this.fontRenderer.field_78303_s = true;
                    obfuscated = true;
                } else if (styleIndex == 17) {
                    this.fontRenderer.field_78302_t = true;
                } else if (styleIndex == 18) {
                    this.fontRenderer.field_78299_w = true;
                } else if (styleIndex == 19) {
                    this.fontRenderer.field_78300_v = true;
                } else if (styleIndex == 20) {
                    this.fontRenderer.field_78301_u = true;
                } else {
                    this.fontRenderer.field_78300_v = false;
                    this.fontRenderer.field_78299_w = false;
                    this.fontRenderer.field_78303_s = false;
                    this.fontRenderer.field_78301_u = false;
                    this.fontRenderer.field_78302_t = false;
                    GlStateManager.func_179131_c((float)red, (float)blue, (float)green, (float)alpha);
                    value.setLastGreen(green);
                    value.setLastAlpha(alpha);
                    value.setLastBlue(blue);
                    value.setLastRed(red);
                }
                ++messageChar;
                continue;
            }
            int n = obfuscationIndex = shadow || this.fontRenderer.field_78303_s ? "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(letter) : 0;
            if (this.fontRenderer.field_78303_s && obfuscationIndex != -1) {
                char charIndex;
                float charWidthFloat = this.getCharWidthFloat(letter);
                while (charWidthFloat != this.getCharWidthFloat(charIndex = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".charAt(obfuscationIndex = this.fontRenderer.field_78289_c.nextInt("\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".length())))) {
                }
                letter = charIndex;
            }
            boolean unicode = this.fontRenderer.field_78293_l;
            float boldWidth = this.getBoldOffset(obfuscationIndex);
            boolean bl = small = (letter == '\u0000' || obfuscationIndex == -1 || unicode) && shadow;
            if (small) {
                this.fontRenderer.field_78295_j -= boldWidth;
                this.fontRenderer.field_78296_k -= boldWidth;
            }
            float effectiveWidth = this.renderChar(letter, this.fontRenderer.field_78301_u);
            if (small) {
                this.fontRenderer.field_78295_j += boldWidth;
                this.fontRenderer.field_78296_k += boldWidth;
            }
            if (this.fontRenderer.field_78302_t) {
                this.fontRenderer.field_78295_j += boldWidth;
                if (small) {
                    this.fontRenderer.field_78295_j -= boldWidth;
                    this.fontRenderer.field_78296_k -= boldWidth;
                }
                this.renderChar(letter, this.fontRenderer.field_78301_u);
                this.fontRenderer.field_78295_j -= boldWidth;
                if (small) {
                    this.fontRenderer.field_78295_j += boldWidth;
                    this.fontRenderer.field_78296_k += boldWidth;
                }
                effectiveWidth += boldWidth;
            }
            if (this.fontRenderer.field_78299_w) {
                this.adjustOrAppend(strikeThough, this.fontRenderer.field_78295_j, effectiveWidth, value.getLastRed(), value.getLastGreen(), value.getLastBlue(), value.getLastAlpha());
            }
            if (this.fontRenderer.field_78300_v) {
                this.adjustOrAppend(underline, this.fontRenderer.field_78295_j, effectiveWidth, value.getLastRed(), value.getLastGreen(), value.getLastBlue(), value.getLastAlpha());
            }
            this.fontRenderer.field_78295_j += effectiveWidth;
        }
        this.endDrawing();
        boolean bl = hasStyle = underline.size() > 0 || strikeThough.size() > 0;
        if (hasStyle) {
            GlStateManager.func_179090_x();
            GL11.glBegin((int)7);
        }
        for (RenderPair renderPair : strikeThough) {
            GlStateManager.func_179131_c((float)renderPair.red, (float)renderPair.green, (float)renderPair.blue, (float)renderPair.alpha);
            GL11.glVertex2f((float)renderPair.posX, (float)(this.fontRenderer.field_78296_k + 4.0f));
            GL11.glVertex2f((float)(renderPair.posX + renderPair.width), (float)(this.fontRenderer.field_78296_k + 4.0f));
            GL11.glVertex2f((float)(renderPair.posX + renderPair.width), (float)(this.fontRenderer.field_78296_k + 3.0f));
            GL11.glVertex2f((float)renderPair.posX, (float)(this.fontRenderer.field_78296_k + 3.0f));
        }
        for (RenderPair renderPair : underline) {
            GlStateManager.func_179131_c((float)renderPair.red, (float)renderPair.green, (float)renderPair.blue, (float)renderPair.alpha);
            float fontHeight = this.fontRenderer.field_78288_b;
            GL11.glVertex2f((float)(renderPair.posX - 1.0f), (float)(this.fontRenderer.field_78296_k + fontHeight));
            GL11.glVertex2f((float)(renderPair.posX + renderPair.width), (float)(this.fontRenderer.field_78296_k + fontHeight));
            GL11.glVertex2f((float)(renderPair.posX + renderPair.width), (float)(this.fontRenderer.field_78296_k + fontHeight - 1.0f));
            GL11.glVertex2f((float)(renderPair.posX - 1.0f), (float)(this.fontRenderer.field_78296_k + fontHeight - 1.0f));
        }
        if (hasStyle) {
            GL11.glEnd();
        }
        GlStateManager.func_179098_w();
        if (cacheFontData) {
            GL11.glEndList();
            this.enhancedFontRenderer.cache(hash, value);
        }
        value.setWidth(this.fontRenderer.field_78295_j);
        this.fontRenderer.field_78296_k = posY + value.getHeight();
        this.fontRenderer.field_78295_j = posX + value.getWidth();
        if (obfuscated) {
            this.enhancedFontRenderer.getObfuscated().add(hash);
        }
        GlStateManager.func_179109_b((float)(-posX), (float)(-posY), (float)0.0f);
        return true;
    }

    private void adjustOrAppend(Deque<RenderPair> underline, float posX, float effectiveWidth, float lastRed, float lastGreen, float lastBlue, float lastAlpha) {
        RenderPair lastStart = underline.peekLast();
        if (lastStart != null && lastStart.red == lastRed && lastStart.green == lastGreen && lastStart.blue == lastBlue && lastStart.alpha == lastAlpha) {
            if (lastStart.posX + lastStart.width >= posX - 1.0f) {
                lastStart.width = posX + effectiveWidth - lastStart.posX;
            }
        } else {
            underline.add(new RenderPair(posX, effectiveWidth, lastRed, lastGreen, lastBlue, lastAlpha));
        }
    }

    private float getBoldOffset(int j) {
        return this.fontRenderer.field_78293_l || j == -1 ? 0.5f : this.getOptifineBoldOffset();
    }

    private float getOptifineBoldOffset() {
        return this.hook.getOptifineBoldOffset(this.fontRenderer);
    }

    public float renderChar(char ch, boolean italic) {
        if (ch == ' ' || ch == '\u00a0') {
            return this.fontRenderer.field_78293_l ? 4.0f : this.getCharWidthFloat(ch);
        }
        int charIndex = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(ch);
        return charIndex != -1 && !this.fontRenderer.field_78293_l ? this.renderDefaultChar(charIndex, italic, ch) : this.renderUnicodeChar(ch, italic);
    }

    protected float renderDefaultChar(int characterIndex, boolean italic, char ch) {
        float characterX = (float)(characterIndex % 16 * 8 * this.regularCharDim >> 7) + 0.01f;
        float characterY = (float)(((characterIndex >> 4) * 8 * this.regularCharDim >> 7) + 16 * this.texSheetDim) + 0.01f;
        boolean italicStyle = italic;
        float charWidth = this.getCharWidthFloat(ch);
        float smallCharWidth = charWidth - 0.01f;
        this.startDrawing();
        float uvHeight = 7.99f * (float)this.regularCharDim / 128.0f;
        float uvWidth = smallCharWidth * (float)this.regularCharDim / 128.0f;
        GL11.glTexCoord2f((float)(characterX / this.fontTexWidth), (float)(characterY / this.fontTexHeight));
        GL11.glVertex2f((float)(this.fontRenderer.field_78295_j + (float)italicStyle), (float)this.fontRenderer.field_78296_k);
        GL11.glTexCoord2f((float)(characterX / this.fontTexWidth), (float)((characterY + uvHeight) / this.fontTexHeight));
        GL11.glVertex2f((float)(this.fontRenderer.field_78295_j - (float)italicStyle), (float)(this.fontRenderer.field_78296_k + 7.99f));
        int offset = this.regularCharDim / 128;
        GL11.glTexCoord2f((float)((characterX + uvWidth - (float)offset) / this.fontTexWidth), (float)((characterY + uvHeight) / this.fontTexHeight));
        GL11.glVertex2f((float)(this.fontRenderer.field_78295_j + smallCharWidth - 1.0f - (float)italicStyle), (float)(this.fontRenderer.field_78296_k + 7.99f));
        GL11.glTexCoord2f((float)((characterX + uvWidth - (float)offset) / this.fontTexWidth), (float)(characterY / this.fontTexHeight));
        GL11.glVertex2f((float)(this.fontRenderer.field_78295_j + smallCharWidth - 1.0f + (float)italicStyle), (float)this.fontRenderer.field_78296_k);
        return charWidth;
    }

    private void startDrawing() {
        if (!this.drawing) {
            this.drawing = true;
            GL11.glBegin((int)7);
        }
    }

    private void endDrawing() {
        if (this.drawing) {
            this.drawing = false;
            GL11.glEnd();
        }
    }

    private Pair<Float, Float> getUV(char characterIndex) {
        int page = characterIndex / 256;
        int row = page / 16;
        int column = page % 16;
        int glyphWidth = this.fontRenderer.field_78287_e[characterIndex] >>> 4;
        float charX = (float)(characterIndex % 16 << 4) + (float)glyphWidth + 0.05f * (float)page / 39.0f;
        float charY = (float)(((characterIndex & 0xFF) >> 4) * 16) + 0.05f * (float)page / 39.0f;
        return new Pair((Object)Float.valueOf(((float)(row * this.texSheetDim) + charX) / this.fontTexWidth), (Object)Float.valueOf(((float)(column * this.texSheetDim) + charY) / this.fontTexHeight));
    }

    protected float renderUnicodeChar(char ch, boolean italic) {
        if (this.fontRenderer.field_78287_e[ch] == 0) {
            return 0.0f;
        }
        Pair<Float, Float> uv = this.getUV(ch);
        int glyphX = this.fontRenderer.field_78287_e[ch] >>> 4;
        int glyphY = this.fontRenderer.field_78287_e[ch] & 0xF;
        float floatGlyphX = glyphX;
        float modifiedY = glyphY + 1;
        float combinedGlyphSize = modifiedY - floatGlyphX - 0.02f;
        float italicStyle = italic ? 1.0f : 0.0f;
        this.startDrawing();
        float v = 15.98f * (float)this.texSheetDim / 256.0f;
        GL11.glTexCoord2f((float)((Float)uv.component1()).floatValue(), (float)((Float)uv.component2()).floatValue());
        GL11.glVertex2f((float)(this.fontRenderer.field_78295_j + italicStyle), (float)this.fontRenderer.field_78296_k);
        GL11.glTexCoord2f((float)((Float)uv.component1()).floatValue(), (float)(((Float)uv.component2()).floatValue() + v / this.fontTexHeight));
        GL11.glVertex2f((float)(this.fontRenderer.field_78295_j - italicStyle), (float)(this.fontRenderer.field_78296_k + 7.99f));
        float texAdj = combinedGlyphSize + 0.5f;
        GL11.glTexCoord2f((float)(((Float)uv.component1()).floatValue() + texAdj / this.fontTexHeight), (float)(((Float)uv.component2()).floatValue() + v / this.fontTexHeight));
        GL11.glVertex2f((float)(this.fontRenderer.field_78295_j + combinedGlyphSize / 2.0f - italicStyle), (float)(this.fontRenderer.field_78296_k + 7.99f));
        GL11.glTexCoord2f((float)(((Float)uv.component1()).floatValue() + texAdj / this.fontTexHeight), (float)((Float)uv.component2()).floatValue());
        GL11.glVertex2f((float)(this.fontRenderer.field_78295_j + combinedGlyphSize / 2.0f + italicStyle), (float)this.fontRenderer.field_78296_k);
        return (modifiedY - floatGlyphX) / 2.0f + 1.0f;
    }

    private float getCharWidthFloat(char c) {
        return this.hook.getCharWidth(this.fontRenderer, c);
    }

    public int getStringWidth(FontRenderer renderer, String text) {
        Map<String, Integer> stringWidthCache = this.enhancedFontRenderer.getStringWidthCache();
        if (!PatcherConfig.optimizedFontRenderer) {
            if (stringWidthCache.size() != 0) {
                stringWidthCache.clear();
            }
            return this.getUncachedWidth(renderer, text);
        }
        if (text == null) {
            return 0;
        }
        if (stringWidthCache.size() > 5000) {
            stringWidthCache.clear();
        }
        return stringWidthCache.computeIfAbsent(text, width -> this.getUncachedWidth(renderer, text));
    }

    private int getUncachedWidth(FontRenderer renderer, String text) {
        if (text == null) {
            return 0;
        }
        float i = 0.0f;
        boolean flag = false;
        for (int j = 0; j < text.length(); ++j) {
            char c0 = text.charAt(j);
            float k = this.getCharWidthFloat(c0);
            if (k < 0.0f && j < text.length() - 1) {
                if ((c0 = text.charAt(++j)) != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag = false;
                    }
                } else {
                    flag = true;
                }
                k = 0.0f;
            }
            i += k;
            if (!flag || !(k > 0.0f)) continue;
            i += this.getBoldOffset("\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(c0));
        }
        return (int)i;
    }

    static class RenderPair {
        private final float red;
        private final float green;
        private final float blue;
        private final float alpha;
        float posX;
        float width;

        public RenderPair(float posX, float width, float red, float green, float blue, float alpha) {
            this.posX = posX;
            this.width = width;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }
    }
}

